<?php include 'header-link.php' ?>
    <?php 
        // Check if the form is submitted
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $offerName = $_POST['OfferName'];
            $amount = $_POST['Amount'];
            $meyad = $_POST['Meyad'];
            $commission = $_POST['Commission'];
            $driveTotal = $_POST['Amount'] + $_POST['Commission'];
            $offerType = $_POST['OfferType'];
            $simName = $_POST['SimName'];
            $area = $_POST['Area'];
            $status = 1;
            

            // Get the latest offer_id and increment it
            $sql = "SELECT MAX(offer_id) AS max_id FROM all_drive_package"; // Replace 'your_table_name' with your actual table name
            $result = $con->query($sql);
            $row = $result->fetch_assoc();
            $newOfferId = $row['max_id'] + 1;

            // Insert the new offer data into the database
            $insertSql = "INSERT INTO all_drive_package (offer_id, offer_name, offer_amount, offer_meyad, offer_commision,drive_total, offer_type, offer_sim, offer_area,status) 
                                                VALUES (?, ?, ?, ?, ?, ?,?, ?, ?,?)";
            
            $stmt = $con->prepare($insertSql);
            $stmt->bind_param("issssssssi", $newOfferId, $offerName, $amount, $meyad, $commission,$driveTotal, $offerType, $simName, $area,$status);

            if ($stmt->execute()) {
                $success_message = "New offer added successfully.";
            } else {
                $error_message = "Error: " . $stmt->error;
            }

            $stmt->close();
        }
?>


    <main>
	
        <section>   
			<div class="container">
				<div class="row justify-content-center">
					<div class="col-md-6">
						<div class="card custom-card">
							<div class="card-body">
								<h6 class="card-title text-center d-block"> Add New Offer </h6>
                                        <?php if (!empty($success_message)): ?>
                                            <div class="alert alert-success"><?php echo $success_message; ?></div>
                                            <?php endif; ?>
                                            <?php if (!empty($error_message)): ?>
                                                <div class="alert alert-danger"><?php echo $error_message; ?></div>
                                        <?php endif; ?>
								
									<form class="form" action="" method="POST">

                                        <div class="mb-3">
                                            <label class="form-label"> Offer Name </label>
                                                <input type="text" name="OfferName" class="form-control" placeholder=" অফারের নাম বাংলায় লিখুন " required>
										</div>

                                        <div class="mb-3">
                                            <label class="form-label"> Offer Amount </label>
                                                <input type="number" name="Amount" class="form-control" placeholder=" Amount (Tk.)" required>
										</div>

                                        <div class="mb-3">
                                            <label class="form-label"> Offer Meyad </label>
                                                <input type="text" name="Meyad" class="form-control" placeholder="Offer Meyad" required>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label"> Commission </label>
                                                <input type="number" name="Commission" class="form-control" placeholder="Commission" required>
                                        </div>

										<div class="mb-3">
                                            <label class="form-label"> Offer Type </label>
                                                <select name="OfferType" class="form-control select-control" required>
                                                    <option value=""> -- Select --</option>
                                                    <option value="Drive"> Drive Offer </option>
                                                    <option value="Package"> Package Offer </option>
                                                </select>
                                           
										</div>

                                        <div class="mb-3">
                                            <label class="form-label"> Offer Sim </label>
                                                <select name="SimName" class="form-control select-control" required>
                                                    <option value=""> -- Select -- </option>
                                                    <?php 
                                                    $sql = "SELECT sim_id, sim_name FROM sim_entry";
                                                    $result = $con->query($sql);
                                                    while ($row = $result->fetch_array()) {
                                                        echo "<option value='" . $row[0] . "'>" . $row[1] . "</option>";
                                                    } 
                                                    ?>
                                                </select>
										</div>

                                        <div class="mb-3">
                                            <label class="form-label"> Offer Area </label>
                                                <select name="Area" class="form-control select-control" required>
                                                    <option value=""> -- Select -- </option>
                                                    <?php 
                                                    $sql = "SELECT dist_id, dist_name FROM district";
                                                    $result = $con->query($sql);
                                                    while ($row = $result->fetch_array()) {
                                                        echo "<option value='" . $row[0] . "'>" . $row[1] . "</option>";
                                                    } 
                                                    ?>
                                                </select>
										</div>
										
										
										<button type="submit" class="btn custom-button"> Save  </button>
									</form>
									
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
		

		
    </main>

    
</body>
</html>
